function ht = tipGap(N, TC, BC, t1, t2)
%UNTITLED5 Summary of this function goes here
%   Detailed explanation goes here
 
filename = 'BearingCenterCoord.xlsx'; 
M =  readmatrix(filename,'Sheet', 1, 'Range', 'A2');
xbear = M(end, 1); ybear = M(end, 2); 

ybear = ybear - BC;

e = sqrt( xbear^2 + ybear^2 );
GAMMA =  rad2deg(mod(atan2(ybear, xbear), 2*pi));

c= 90;
twear = [0, 25  75, 110, 156, 175 200 220] + c; 
hwear = [0, 0 0.0008 .001, .007, 0.018, 0.03 0.035];
hw = @(t) makima(twear,(hwear), t).*(t>=c) + 0.*(t<c);

ht_nom = TC*ones(1, N + 1);
tt = t1 + (0:N).*(t2 - t1)/N;
ht = ht_nom - e.*cosd(tt - GAMMA); 
ht = ht + hw(tt);

ht = flip(ht);

end